/*******************************************************************************
*
*  Project name : matchcode generator for iCalamus 2.0
*  Header name  : code generator global definitions
*  Symbol prefix: ic_code_
*
*  Author       : Michael Monscheuer (MM)
*  Co-Authors   : Ulf Dunkel (fd)
*  Write access : fd
*
*  Notes        : -
*-------------------------------------------------------------------------------
*  Things to do : -
*
*-------------------------------------------------------------------------------
*  History:
*
*  2006:
*    fd  Apr 19: introduced (extracted from CALCCODE.C)
*  2012:
*    fd  Mar 02: USTR_OEM re-added (from iCalamus 1.0)
*  2013:
*    fd  Feb 28: iCalamus 2 serialization stuff added
*    fd  May 27: code header changed for beta period
*    fd  Oct 08: USTR_OEM removed -> now defined in CALSerialCenter.h
*    fd  Nov 11: code header updated after beta period
*
******************************************|************************************/
/*KEY _NAME="iCalamus code generator global definitions" */
/*END*/


#ifndef __IC2_CODE_GLMOD
#define __IC2_CODE_GLMOD





/*******************************************************************************
*
*     MACRO DEFINITIONS
*
******************************************|************************************/

   /* --- iCalamus 2.0 --- */

#define UKEY_IC2      0x2F90E812          /* 19000613 * 42 */
#define USTR_IC2     "IC20"               /* code header */

/* --- coding keys --- */
#define CKEY2         0x30512B50          /* 19300616 * 42 */
#define CKEY3         0x3071677E          /* 19350915 * 42 */


   /* silly content   123456789012345678901234567890123456789012345678901234567890  (60 chars) */
#define VF           "Blak2j3i4na skhjreiaj4947F293Aa 323F4as947 3o9dfeAgoa CB1234"

                                          /* allowed characters for <USER NAME> */
#define CHARS_OK      "-.+&/()' 1234567890 ABCDEFGHIJKLMNOPQRSTUVWXYZ"







/*******************************************************************************
*
*     GLOBAL PROTOTYPES
*
******************************************|************************************/

   /* code generator function */
void ic_code_calc(uint32_t key, char *text, char *code);





#endif  /* ifndef __IC2_CODE_GLMOD */


/* +++ EOF +++ */